<?php
require_once __DIR__ . '/../includes/auth_check.php';
require_once __DIR__ . '/../config/db.php';

header('Content-Type: application/json');

$query = $_GET['q'] ?? '';
$query = strtolower(trim($query));

if (empty($query)) {
    echo json_encode(['error' => 'Consulta vacía']);
    exit;
}

$response = [
    'query' => $query,
    'acciones' => [],
    'sugerencias' => []
];

// Análisis de la consulta
if (strpos($query, 'stock bajo') !== false || strpos($query, 'bajo stock') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Ver productos con stock bajo',
        'url' => '/inventario/cintas/listar.php?stock=bajo',
        'icono' => '⚠️',
        'descripcion' => 'Mostrar productos que están por debajo del stock mínimo'
    ];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM cintas WHERE activo = 1 AND stock < stock_minimo");
    $total = $stmt->fetchColumn();
    $response['sugerencias'][] = "Actualmente hay $total productos con stock bajo";
}

if (strpos($query, 'stock crítico') !== false || strpos($query, 'crítico') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Ver stock crítico',
        'url' => '/inventario/cintas/listar.php?stock=critico',
        'icono' => '🚨',
        'descripcion' => 'Productos con menos del 50% del stock mínimo'
    ];
}

if (strpos($query, 'sin stock') !== false || strpos($query, 'agotado') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Ver productos sin stock',
        'url' => '/inventario/cintas/listar.php?stock=sin_stock',
        'icono' => '📭',
        'descripcion' => 'Productos completamente agotados'
    ];
}

if (strpos($query, 'reporte') !== false || strpos($query, 'informe') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Generar reportes',
        'url' => '/inventario/reportes/generar.php',
        'icono' => '📊',
        'descripcion' => 'Acceder al sistema de reportes'
    ];
    
    if (strpos($query, 'mensual') !== false) {
        $response['acciones'][] = [
            'titulo' => 'Reporte mensual',
            'url' => '/inventario/reportes/generar.php?periodo=mes',
            'icono' => '📅',
            'descripcion' => 'Reporte del mes actual'
        ];
    }
    
    if (strpos($query, 'semanal') !== false) {
        $response['acciones'][] = [
            'titulo' => 'Reporte semanal',
            'url' => '/inventario/reportes/generar.php?periodo=semana',
            'icono' => '📅',
            'descripcion' => 'Reporte de esta semana'
        ];
    }
}

if (strpos($query, 'ingreso') !== false || strpos($query, 'entrada') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Registrar ingreso',
        'url' => '/inventario/movimientos/ingreso.php',
        'icono' => '➕',
        'descripcion' => 'Registrar entrada de productos al inventario'
    ];
}

if (strpos($query, 'salida') !== false || strpos($query, 'egreso') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Registrar salida',
        'url' => '/inventario/movimientos/salida.php',
        'icono' => '➖',
        'descripcion' => 'Registrar salida de productos del inventario'
    ];
}

if (strpos($query, 'nuevo producto') !== false || strpos($query, 'agregar producto') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Agregar nuevo producto',
        'url' => '/inventario/cintas/agregar.php',
        'icono' => '📦',
        'descripcion' => 'Registrar un nuevo producto en el inventario'
    ];
}

if (strpos($query, 'historial') !== false || strpos($query, 'movimientos') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Ver historial',
        'url' => '/inventario/movimientos/historial.php',
        'icono' => '📜',
        'descripcion' => 'Historial completo de movimientos'
    ];
}

if (strpos($query, 'categoría') !== false || strpos($query, 'categorias') !== false) {
    $response['acciones'][] = [
        'titulo' => 'Gestionar categorías',
        'url' => '/inventario/categorias/agregar.php',
        'icono' => '📂',
        'descripcion' => 'Administrar categorías de productos'
    ];
}

// Búsqueda de productos específicos
if (strlen($query) > 2) {
    $stmt = $pdo->prepare("
        SELECT codigo, descripcion 
        FROM cintas 
        WHERE (codigo LIKE ? OR descripcion LIKE ?) AND activo = 1
        LIMIT 3
    ");
    $searchTerm = "%$query%";
    $stmt->execute([$searchTerm, $searchTerm]);
    $productos = $stmt->fetchAll();
    
    foreach ($productos as $producto) {
        $response['acciones'][] = [
            'titulo' => "Buscar: " . $producto['codigo'],
            'url' => '/inventario/cintas/listar.php?q=' . urlencode($producto['codigo']),
            'icono' => '🔍',
            'descripcion' => $producto['descripcion']
        ];
    }
}

// Si no se encontraron acciones, ofrecer ayuda general
if (empty($response['acciones'])) {
    $response['sugerencias'] = [
        "Puedo ayudarte con: stock bajo, reportes, ingresos, salidas, historial",
        "Intenta ser más específico, por ejemplo: 'ver stock bajo' o 'generar reporte mensual'",
        "También puedes buscar productos por código o descripción"
    ];
    
    $response['acciones'] = [
        [
            'titulo' => 'Explorar inventario',
            'url' => '/inventario/cintas/listar.php',
            'icono' => '📦',
            'descripcion' => 'Ver todos los productos'
        ],
        [
            'titulo' => 'Sistema de reportes',
            'url' => '/inventario/reportes/generar.php',
            'icono' => '📊',
            'descripcion' => 'Generar reportes del sistema'
        ]
    ];
}

echo json_encode($response);
?>