<?php
require_once __DIR__ . '/../includes/auth_check.php';
require_once __DIR__ . '/../config/db.php';

header('Content-Type: application/json');

$busqueda = $_GET['q'] ?? '';
$categoria_filtro = $_GET['categoria'] ?? '';
$filtro_stock = $_GET['stock'] ?? '';

// Construir consulta con filtros
$whereConditions = [];
$params = [];

if (!empty($busqueda)) {
    $whereConditions[] = "(c.codigo LIKE :busqueda OR c.descripcion LIKE :busqueda)";
    $params[':busqueda'] = "%$busqueda%";
}

if (!empty($categoria_filtro)) {
    $whereConditions[] = "c.categoria_id = :categoria_id";
    $params[':categoria_id'] = $categoria_filtro;
}

// Filtro de stock avanzado
if (!empty($filtro_stock)) {
    switch ($filtro_stock) {
        case 'bajo':
            $whereConditions[] = "c.stock < c.stock_minimo AND c.stock > 0";
            break;
        case 'critico':
            $whereConditions[] = "c.stock < (c.stock_minimo * 0.5) AND c.stock > 0";
            break;
        case 'sin_stock':
            $whereConditions[] = "c.stock = 0";
            break;
        case 'stock_ok':
            $whereConditions[] = "c.stock >= c.stock_minimo";
            break;
    }
}

// Solo productos activos
$whereConditions[] = "c.activo = 1";

$whereClause = '';
if (!empty($whereConditions)) {
    $whereClause = 'WHERE ' . implode(' AND ', $whereConditions);
}

// Consulta principal
$sql = "SELECT c.*, cat.nombre AS categoria, cat.id AS categoria_id
        FROM cintas c 
        LEFT JOIN categorias cat ON c.categoria_id = cat.id
        $whereClause
        ORDER BY cat.nombre, c.codigo
        LIMIT 50";

$stmt = $pdo->prepare($sql);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->execute();
$resultados = $stmt->fetchAll();

// Función para traducir unidad
function traducirUnidad($u) {
    switch ($u) {
        case 'm': return 'Metros';
        case 'kg': return 'Kilos';
        case 'u': return 'Unidades';
        default: return $u;
    }
}

// Preparar respuesta
$response = [];
foreach ($resultados as $cinta) {
    $valorStock = $cinta['stock'] * $cinta['precio_unitario'];
    
    $response[] = [
        'id' => $cinta['id'],
        'codigo' => htmlspecialchars($cinta['codigo']),
        'descripcion' => htmlspecialchars($cinta['descripcion']),
        'categoria' => htmlspecialchars($cinta['categoria']),
        'unidad' => traducirUnidad($cinta['unidad']),
        'precio_unitario' => number_format($cinta['precio_unitario'], 0, '', '.'),
        'stock' => number_format($cinta['stock'], 0, '', '.'),
        'stock_minimo' => number_format($cinta['stock_minimo'], 0, '', '.'),
        'valor_stock' => number_format($valorStock, 0, '', '.'),
        'alerta_stock' => $cinta['stock'] < $cinta['stock_minimo'] ? 'warning' : ($cinta['stock'] == 0 ? 'danger' : 'success')
    ];
}

echo json_encode($response);
?>