<?php
require_once __DIR__ . '/../includes/auth_check.php';
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';

if ($_SESSION['usuario']['rol'] !== 'admin') {
    die("Acceso denegado.");
}

$errores = [];
$mensaje = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = trim($_POST['codigo']);
    $descripcion = trim($_POST['descripcion']);
    $unidad = $_POST['unidad'];
    $precio = (float)$_POST['precio_unitario'];
    $stock = (float)$_POST['stock'];
    $stock_minimo = (float)($_POST['stock_minimo'] ?? 5);
    $categoria_id = $_POST['categoria_id'];

    // Validaciones
    if (empty($codigo)) {
        $errores[] = "El código es obligatorio.";
    }
    
    if (empty($descripcion)) {
        $errores[] = "La descripción es obligatoria.";
    }
    
    if ($precio <= 0) {
        $errores[] = "El precio unitario debe ser mayor a cero.";
    }
    
    if ($stock < 0) {
        $errores[] = "El stock no puede ser negativo.";
    }
    
    if ($stock_minimo < 0) {
        $errores[] = "El stock mínimo no puede ser negativo.";
    }

    // Verificar si el código ya existe
    $stmt = $pdo->prepare("SELECT id FROM cintas WHERE codigo = ?");
    $stmt->execute([$codigo]);
    if ($stmt->fetch()) {
        $errores[] = "El código '$codigo' ya existe. Por favor usa otro código.";
    }

    if (empty($errores)) {
        try {
            $pdo->beginTransaction();
            
            $stmt = $pdo->prepare("INSERT INTO cintas (codigo, descripcion, unidad, precio_unitario, stock, stock_minimo, categoria_id) 
                                   VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$codigo, $descripcion, $unidad, $precio, $stock, $stock_minimo, $categoria_id]);
            
            $pdo->commit();
            
            $mensaje = "✅ Producto agregado correctamente. ";
            $mensaje .= "<a href='agregar.php' class='alert-link'>Agregar otro producto</a> o ";
            $mensaje .= "<a href='listar.php' class='alert-link'>ver el inventario</a>.";
            
            // Limpiar formulario
            $_POST = [];
            
        } catch (Exception $e) {
            $pdo->rollBack();
            $errores[] = "Error al guardar el producto: " . $e->getMessage();
        }
    }
}

$categorias = $pdo->query("SELECT * FROM categorias ORDER BY nombre")->fetchAll();
?>
<h3 class="mb-4">➕ Agregar Producto</h3>

<?php if(!empty($errores)): ?>
    <div class="alert alert-danger">
        <h6>❌ Errores encontrados:</h6>
        <ul class="mb-0">
            <?php foreach ($errores as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<?php if($mensaje): ?>
    <div class="alert alert-success"><?= $mensaje ?></div>
<?php endif; ?>

<form method="POST" class="card p-4 shadow-sm">
    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">Código <span class="text-danger">*</span></label>
                <input type="text" name="codigo" value="<?= isset($_POST['codigo']) ? htmlspecialchars($_POST['codigo']) : '' ?>" 
                       class="form-control" required maxlength="50" 
                       placeholder="Ej: SARGA-ROJO, COLCHON-50MM">
                <div class="form-text">Código único para identificar el producto.</div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">Categoría <span class="text-danger">*</span></label>
                <select name="categoria_id" class="form-select" required>
                    <option value="">-- Seleccionar Categoría --</option>
                    <?php foreach ($categorias as $cat): ?>
                        <option value="<?= $cat['id'] ?>" 
                                <?= (isset($_POST['categoria_id']) && $_POST['categoria_id'] == $cat['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($cat['nombre']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label">Descripción <span class="text-danger">*</span></label>
        <input type="text" name="descripcion" value="<?= isset($_POST['descripcion']) ? htmlspecialchars($_POST['descripcion']) : '' ?>" 
               class="form-control" required maxlength="255"
               placeholder="Descripción detallada del producto">
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="mb-3">
                <label class="form-label">Unidad de medida <span class="text-danger">*</span></label>
                <select name="unidad" class="form-select" required>
                    <option value="m" <?= (isset($_POST['unidad']) && $_POST['unidad'] == 'm') ? 'selected' : '' ?>>Metros (m)</option>
                    <option value="kg" <?= (isset($_POST['unidad']) && $_POST['unidad'] == 'kg') ? 'selected' : '' ?>>Kilos (kg)</option>
                    <option value="u" <?= (isset($_POST['unidad']) && $_POST['unidad'] == 'u') ? 'selected' : '' ?>>Unidades (u)</option>
                </select>
            </div>
        </div>
        <div class="col-md-3">
            <div class="mb-3">
                <label class="form-label">Precio Unitario (CLP) <span class="text-danger">*</span></label>
                <input type="number" step="0.01" min="0.01" name="precio_unitario" 
                       value="<?= isset($_POST['precio_unitario']) ? htmlspecialchars($_POST['precio_unitario']) : '' ?>" 
                       class="form-control" required
                       placeholder="Ej: 1200.00">
            </div>
        </div>
        <div class="col-md-3">
            <div class="mb-3">
                <label class="form-label">Stock Inicial <span class="text-danger">*</span></label>
                <input type="number" step="0.01" min="0" name="stock" 
                       value="<?= isset($_POST['stock']) ? htmlspecialchars($_POST['stock']) : '0' ?>" 
                       class="form-control" required
                       placeholder="Ej: 100, 50.5">
            </div>
        </div>
        <div class="col-md-3">
            <div class="mb-3">
                <label class="form-label">Stock Mínimo</label>
                <input type="number" step="0.01" min="0" name="stock_minimo" 
                       value="<?= isset($_POST['stock_minimo']) ? htmlspecialchars($_POST['stock_minimo']) : '5' ?>" 
                       class="form-control"
                       placeholder="Ej: 5">
                <div class="form-text">Se alertará cuando el stock esté por debajo de este valor.</div>
            </div>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary btn-lg py-2">
            💾 Guardar Producto
        </button>
        <a href="/inventario/cintas/listar.php" class="btn btn-outline-secondary">
            📦 Volver al Inventario
        </a>
    </div>
</form>

<?php include __DIR__ . '/../includes/footer.php'; ?>