<?php
// Configuración de la base de datos
$host = 'localhost';
$db   = 'jusocar_control';
$user = 'root';
$pass = ''; // en XAMPP normalmente está vacío
$charset = 'utf8mb4';

// Opciones de PDO
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
    PDO::ATTR_PERSISTENT         => false,
    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
];

try {
    $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    $pdo = new PDO($dsn, $user, $pass, $options);
    
    // Configurar timezone para la conexión
    $pdo->exec("SET time_zone = '-03:00'");
    
} catch (PDOException $e) {
    // Log del error (no mostrar detalles sensibles al usuario)
    error_log("Error de conexión a BD: " . $e->getMessage());
    
    // Mensaje amigable al usuario
    die("
        <div class='container mt-5'>
            <div class='alert alert-danger text-center'>
                <h4>⚠️ Error de Conexión</h4>
                <p>No se pudo conectar con la base de datos. Por favor intenta más tarde.</p>
                <small>Si el problema persiste, contacta al administrador del sistema.</small>
            </div>
        </div>
    ");
}

// Verificar si las funciones ya existen antes de declararlas
if (!function_exists('formatearFecha')) {
    // Función auxiliar para formatear fechas
    function formatearFecha($fecha, $formato = 'd/m/Y H:i') {
        if (!$fecha) return '-';
        return date($formato, strtotime($fecha));
    }
}

if (!function_exists('formatearMoneda')) {
    // Función para formatear moneda
    function formatearMoneda($valor) {
        return '$' . number_format($valor, 0, '', '.') . ' CLP';
    }
}

if (!function_exists('sanitizar')) {
    // Función para sanitizar datos
    function sanitizar($data) {
        if (is_array($data)) {
            return array_map('sanitizar', $data);
        }
        return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
    }
}

if (!function_exists('validarNumeroPositivo')) {
    // Función para validar número positivo
    function validarNumeroPositivo($numero) {
        return is_numeric($numero) && $numero >= 0;
    }
}

if (!function_exists('validarEmail')) {
    // Función para validar email
    function validarEmail($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }
}

if (!function_exists('registrarAuditoria')) {
    // Función para registrar en auditoría
    function registrarAuditoria($pdo, $tabla, $accion, $registro_id, $valores_anteriores = null, $valores_nuevos = null, $usuario_id = null) {
        try {
            $stmt = $pdo->prepare("
                INSERT INTO auditoria (tabla, accion, registro_id, valores_anteriores, valores_nuevos, usuario_id) 
                VALUES (?, ?, ?, ?, ?, ?)
            ");
            
            $valores_anteriores_json = $valores_anteriores ? json_encode($valores_anteriores) : null;
            $valores_nuevos_json = $valores_nuevos ? json_encode($valores_nuevos) : null;
            
            return $stmt->execute([
                $tabla, 
                $accion, 
                $registro_id, 
                $valores_anteriores_json, 
                $valores_nuevos_json,
                $usuario_id
            ]);
            
        } catch (Exception $e) {
            error_log("Error en auditoría: " . $e->getMessage());
            return false;
        }
    }
}
?>