<?php
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/config/db.php';

header('Content-Type: application/json');

// Verificar que el usuario esté autenticado
if (!isset($_SESSION['usuario'])) {
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

// Datos para gráfico de movimientos últimos 30 días
$stmt = $pdo->query("
    SELECT 
        DATE(fecha) as dia,
        COUNT(*) as total,
        SUM(CASE WHEN tipo = 'ingreso' THEN 1 ELSE 0 END) as ingresos,
        SUM(CASE WHEN tipo = 'salida' THEN 1 ELSE 0 END) as salidas
    FROM movimientos 
    WHERE fecha >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
    GROUP BY DATE(fecha)
    ORDER BY dia ASC
");
$movimientosDias = $stmt->fetchAll();

// Datos para gráfico de stock por categoría
$stmt = $pdo->query("
    SELECT 
        cat.nombre as categoria,
        COUNT(c.id) as total_productos,
        SUM(c.stock) as stock_total,
        SUM(c.stock * c.precio_unitario) as valor_total
    FROM categorias cat
    LEFT JOIN cintas c ON cat.id = c.categoria_id AND c.activo = 1
    GROUP BY cat.id, cat.nombre
    ORDER BY stock_total DESC
");
$stockCategorias = $stmt->fetchAll();

// Datos para gráfico de productos con stock bajo
$stmt = $pdo->query("
    SELECT 
        CASE 
            WHEN stock = 0 THEN 'Sin Stock'
            WHEN stock < (stock_minimo * 0.5) THEN 'Crítico'
            WHEN stock < stock_minimo THEN 'Bajo'
            ELSE 'Normal'
        END as estado,
        COUNT(*) as cantidad
    FROM cintas 
    WHERE activo = 1
    GROUP BY estado
    ORDER BY 
        CASE estado
            WHEN 'Sin Stock' THEN 1
            WHEN 'Crítico' THEN 2
            WHEN 'Bajo' THEN 3
            ELSE 4
        END
");
$estadosStock = $stmt->fetchAll();

$response = [
    'movimientos' => [
        'labels' => [],
        'ingresos' => [],
        'salidas' => [],
        'totales' => []
    ],
    'categorias' => [
        'labels' => [],
        'productos' => [],
        'stock' => [],
        'valor' => []
    ],
    'estados' => [
        'labels' => [],
        'cantidades' => [],
        'colores' => ['#dc3545', '#ffc107', '#fd7e14', '#28a745']
    ]
];

// Procesar datos de movimientos
foreach ($movimientosDias as $dia) {
    $response['movimientos']['labels'][] = date('d/m', strtotime($dia['dia']));
    $response['movimientos']['ingresos'][] = (int)$dia['ingresos'];
    $response['movimientos']['salidas'][] = (int)$dia['salidas'];
    $response['movimientos']['totales'][] = (int)$dia['total'];
}

// Procesar datos de categorías
foreach ($stockCategorias as $cat) {
    $response['categorias']['labels'][] = $cat['categoria'];
    $response['categorias']['productos'][] = (int)$cat['total_productos'];
    $response['categorias']['stock'][] = (int)$cat['stock_total'];
    $response['categorias']['valor'][] = (float)$cat['valor_total'];
}

// Procesar datos de estados de stock
foreach ($estadosStock as $estado) {
    $response['estados']['labels'][] = $estado['estado'];
    $response['estados']['cantidades'][] = (int)$estado['cantidad'];
}

echo json_encode($response);
?>