<?php
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/config/db.php';

if (!isset($_SESSION['usuario'])) {
    die("Acceso no autorizado.");
}

$tipo = $_GET['tipo'] ?? 'inventario';
$formato = $_GET['formato'] ?? 'excel';

// Función para traducir unidad
function traducirUnidad($u) {
    switch ($u) {
        case 'm': return 'Metros';
        case 'kg': return 'Kilos';
        case 'u': return 'Unidades';
        default: return $u;
    }
}

// Función para formatear moneda
function formatearMoneda($valor) {
    return '$' . number_format($valor, 0, '', '.') . ' CLP';
}

if ($tipo === 'inventario') {
    // Exportar inventario completo
    $sql = "SELECT c.*, cat.nombre as categoria, 
                   (c.stock * c.precio_unitario) as valor_total
            FROM cintas c 
            LEFT JOIN categorias cat ON c.categoria_id = cat.id
            WHERE c.activo = 1
            ORDER BY cat.nombre, c.codigo";
    $stmt = $pdo->query($sql);
    $datos = $stmt->fetchAll();
    
    $nombreArchivo = "inventario_completo_" . date('Y-m-d');
    
} elseif ($tipo === 'movimientos') {
    // Exportar movimientos
    $fecha_inicio = $_GET['fecha_inicio'] ?? date('Y-m-01');
    $fecha_fin = $_GET['fecha_fin'] ?? date('Y-m-d');
    
    $sql = "SELECT m.*, c.codigo, c.descripcion, c.precio_unitario,
                   cat.nombre as categoria, u.usuario as usuario_nombre,
                   (m.cantidad * c.precio_unitario) as valor_movimiento
            FROM movimientos m
            JOIN cintas c ON m.cinta_id = c.id
            LEFT JOIN categorias cat ON c.categoria_id = cat.id
            LEFT JOIN usuarios u ON m.usuario_id = u.id
            WHERE DATE(m.fecha) BETWEEN ? AND ?
            ORDER BY m.fecha DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $datos = $stmt->fetchAll();
    
    $nombreArchivo = "movimientos_{$fecha_inicio}_a_{$fecha_fin}";
}

if ($formato === 'excel') {
    header("Content-Type: application/vnd.ms-excel; charset=utf-8");
    header("Content-Disposition: attachment; filename={$nombreArchivo}.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    
    echo "<html>";
    echo "<head>";
    echo "<meta charset='UTF-8'>";
    echo "<style>";
    echo "table { border-collapse: collapse; width: 100%; font-family: Arial, sans-serif; }";
    echo "th, td { border: 1px solid #000; padding: 8px; text-align: left; }";
    echo "th { background-color: #f2f2f2; font-weight: bold; }";
    echo ".number { text-align: right; }";
    echo ".text-center { text-align: center; }";
    echo ".total { background-color: #e9ecef; font-weight: bold; }";
    echo ".success { background-color: #d4edda; }";
    echo ".warning { background-color: #fff3cd; }";
    echo ".danger { background-color: #f8d7da; }";
    echo "</style>";
    echo "</head>";
    echo "<body>";
    
    if ($tipo === 'inventario') {
        echo "<h2>Reporte de Inventario - Jusocar</h2>";
        echo "<p><strong>Generado:</strong> " . date('d/m/Y H:i:s') . "</p>";
        echo "<p><strong>Total productos:</strong> " . count($datos) . "</p>";
        
        echo "<table>";
        echo "<tr>";
        echo "<th>Categoría</th>";
        echo "<th>Código</th>";
        echo "<th>Descripción</th>";
        echo "<th>Unidad</th>";
        echo "<th>Precio Unitario</th>";
        echo "<th>Stock</th>";
        echo "<th>Stock Mínimo</th>";
        echo "<th>Valor Total</th>";
        echo "<th>Estado</th>";
        echo "</tr>";
        
        $totalValor = 0;
        foreach ($datos as $item) {
            $valorTotal = $item['stock'] * $item['precio_unitario'];
            $totalValor += $valorTotal;
            
            $estado = '';
            if ($item['stock'] == 0) {
                $estado = 'SIN STOCK';
            } elseif ($item['stock'] < $item['stock_minimo']) {
                $estado = 'STOCK BAJO';
            } else {
                $estado = 'NORMAL';
            }
            
            echo "<tr>";
            echo "<td>" . htmlspecialchars($item['categoria']) . "</td>";
            echo "<td>" . htmlspecialchars($item['codigo']) . "</td>";
            echo "<td>" . htmlspecialchars($item['descripcion']) . "</td>";
            echo "<td class='text-center'>" . traducirUnidad($item['unidad']) . "</td>";
            echo "<td class='number'>" . formatearMoneda($item['precio_unitario']) . "</td>";
            echo "<td class='number'>" . number_format($item['stock'], 0, '', '.') . "</td>";
            echo "<td class='number'>" . number_format($item['stock_minimo'], 0, '', '.') . "</td>";
            echo "<td class='number'>" . formatearMoneda($valorTotal) . "</td>";
            echo "<td class='text-center'>" . $estado . "</td>";
            echo "</tr>";
        }
        
        echo "<tr class='total'>";
        echo "<td colspan='7' class='number'><strong>TOTAL GENERAL:</strong></td>";
        echo "<td class='number'><strong>" . formatearMoneda($totalValor) . "</strong></td>";
        echo "<td></td>";
        echo "</tr>";
        echo "</table>";
        
    } elseif ($tipo === 'movimientos') {
        echo "<h2>Reporte de Movimientos - Jusocar</h2>";
        echo "<p><strong>Período:</strong> $fecha_inicio al $fecha_fin</p>";
        echo "<p><strong>Generado:</strong> " . date('d/m/Y H:i:s') . "</p>";
        echo "<p><strong>Total movimientos:</strong> " . count($datos) . "</p>";
        
        echo "<table>";
        echo "<tr>";
        echo "<th>Fecha</th>";
        echo "<th>Tipo</th>";
        echo "<th>Categoría</th>";
        echo "<th>Código</th>";
        echo "<th>Descripción</th>";
        echo "<th>Cantidad</th>";
        echo "<th>Unidad</th>";
        echo "<th>Precio Unitario</th>";
        echo "<th>Valor Movimiento</th>";
        echo "<th>Documento</th>";
        echo "<th>Usuario</th>";
        echo "</tr>";
        
        $totalIngresos = 0;
        $totalSalidas = 0;
        foreach ($datos as $item) {
            $valor = $item['cantidad'] * $item['precio_unitario'];
            
            if ($item['tipo'] === 'ingreso') {
                $totalIngresos += $valor;
            } else {
                $totalSalidas += $valor;
            }
            
            echo "<tr>";
            echo "<td>" . date('d/m/Y H:i', strtotime($item['fecha'])) . "</td>";
            echo "<td class='text-center'>" . strtoupper($item['tipo']) . "</td>";
            echo "<td>" . htmlspecialchars($item['categoria']) . "</td>";
            echo "<td>" . htmlspecialchars($item['codigo']) . "</td>";
            echo "<td>" . htmlspecialchars($item['descripcion']) . "</td>";
            echo "<td class='number'>" . number_format($item['cantidad'], 0, '', '.') . "</td>";
            echo "<td class='text-center'>" . traducirUnidad($item['unidad']) . "</td>";
            echo "<td class='number'>" . formatearMoneda($item['precio_unitario']) . "</td>";
            echo "<td class='number'>" . formatearMoneda($valor) . "</td>";
            echo "<td>" . ($item['tipo_doc'] ?? '-') . ": " . ($item['documento'] ?? '-') . "</td>";
            echo "<td>" . htmlspecialchars($item['usuario_nombre'] ?? 'Sistema') . "</td>";
            echo "</tr>";
        }
        
        echo "<tr class='total'>";
        echo "<td colspan='8' class='number'><strong>TOTAL INGRESOS:</strong></td>";
        echo "<td class='number'><strong>" . formatearMoneda($totalIngresos) . "</strong></td>";
        echo "<td colspan='2'></td>";
        echo "</tr>";
        
        echo "<tr class='total'>";
        echo "<td colspan='8' class='number'><strong>TOTAL SALIDAS:</strong></td>";
        echo "<td class='number'><strong>" . formatearMoneda($totalSalidas) . "</strong></td>";
        echo "<td colspan='2'></td>";
        echo "</tr>";
        
        echo "<tr class='total'>";
        echo "<td colspan='8' class='number'><strong>NETO:</strong></td>";
        echo "<td class='number'><strong>" . formatearMoneda($totalIngresos - $totalSalidas) . "</strong></td>";
        echo "<td colspan='2'></td>";
        echo "</tr>";
        echo "</table>";
    }
    
    echo "</body></html>";
    
} elseif ($formato === 'pdf') {
    // Para PDF necesitarías una librería como TCPDF o Dompdf
    // Por ahora redirigimos a Excel
    header("Location: exportar.php?tipo=$tipo&formato=excel" . 
           (isset($_GET['fecha_inicio']) ? "&fecha_inicio={$_GET['fecha_inicio']}" : "") .
           (isset($_GET['fecha_fin']) ? "&fecha_fin={$_GET['fecha_fin']}" : ""));
}

exit;
?>