</div> <!-- cierre container -->

<!-- Sistema de Métricas de Uso -->
<div class="container-fluid bg-dark text-light mt-5">
    <div class="container py-4">
        <div class="row text-center">
            <div class="col-md-3">
                <div class="metric-small">
                    <i class="bi bi-clock fs-4 text-primary"></i>
                    <div class="h5 mb-1 mt-2" id="tiempoSesion">00:00:00</div>
                    <small class="text-muted">Tiempo en sesión</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="metric-small">
                    <i class="bi bi-activity fs-4 text-success"></i>
                    <div class="h5 mb-1 mt-2"><?= $movimientosHoy ?? '0' ?></div>
                    <small class="text-muted">Movimientos hoy</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="metric-small">
                    <i class="bi bi-lightning fs-4 text-warning"></i>
                    <div class="h5 mb-1 mt-2" id="eficienciaUsuario">0%</div>
                    <small class="text-muted">Eficiencia</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="metric-small">
                    <i class="bi bi-cpu fs-4 text-info"></i>
                    <div class="h5 mb-1 mt-2" id="productividadUsuario">0</div>
                    <small class="text-muted">Puntos productividad</small>
                </div>
            </div>
        </div>
    </div>
</div>

<footer class="bg-gradient-primary text-white py-4">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <p class="mb-0">&copy; <?= date('Y') ?> Jusocar - Control Inventario v2.0</p>
                <small class="opacity-75">Sistema optimizado para gestión eficiente</small>
            </div>
            <div class="col-md-6 text-md-end">
                <button class="btn btn-sm btn-outline-light me-2" onclick="mostrarFeedback()">
                    <i class="bi bi-chat-left-text me-1"></i> Enviar Feedback
                </button>
                <button class="btn btn-sm btn-outline-light" onclick="mostrarEstadisticas()">
                    <i class="bi bi-graph-up me-1"></i> Mis Estadísticas
                </button>
            </div>
        </div>
    </div>
</footer>

<!-- Modal de Feedback -->
<div class="modal fade" id="feedbackModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-gradient-info text-white">
                <h5 class="modal-title">💬 Enviar Feedback</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Tipo de feedback</label>
                    <select class="form-select" id="tipoFeedback">
                        <option value="sugerencia">💡 Sugerencia</option>
                        <option value="problema">🐛 Reportar problema</option>
                        <option value="mejora">🚀 Idea de mejora</option>
                        <option value="felicitacion">🎉 Felicitación</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Tu mensaje</label>
                    <textarea class="form-control" rows="4" id="mensajeFeedback" 
                              placeholder="Cuéntanos qué piensas del sistema..."></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Calificación</label>
                    <div class="d-flex gap-2" id="calificacionEstrellas">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <i class="bi bi-star fs-4 text-muted estrella-calificacion" 
                               data-puntuacion="<?= $i ?>" 
                               onmouseover="resaltarEstrellas(<?= $i ?>)" 
                               onmouseout="restablecerEstrellas()" 
                               onclick="seleccionarEstrellas(<?= $i ?>)"></i>
                        <?php endfor; ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="enviarFeedback()">Enviar Feedback</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Estadísticas Personales -->
<div class="modal fade" id="estadisticasModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-gradient-success text-white">
                <h5 class="modal-title">📊 Mis Estadísticas de Uso</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>📈 Actividad General</h6>
                        <div class="list-group list-group-flush">
                            <div class="list-group-item d-flex justify-content-between">
                                <span>Sesión actual:</span>
                                <strong id="estadisticaSesion">00:00:00</strong>
                            </div>
                            <div class="list-group-item d-flex justify-content-between">
                                <span>Movimientos hoy:</span>
                                <strong><?= $movimientosHoy ?? '0' ?></strong>
                            </div>
                            <div class="list-group-item d-flex justify-content-between">
                                <span>Búsquedas realizadas:</span>
                                <strong id="estadisticaBusquedas">0</strong>
                            </div>
                            <div class="list-group-item d-flex justify-content-between">
                                <span>Productos visitados:</span>
                                <strong id="estadisticaVisitados">0</strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h6>🏆 Logros</h6>
                        <div id="logrosUsuario" class="d-flex flex-wrap gap-2">
                            <!-- Logros se cargan dinámicamente -->
                        </div>
                        
                        <h6 class="mt-4">📅 Resumen Semanal</h6>
                        <canvas id="estadisticasSemanaChart" height="150"></canvas>
                    </div>
                </div>
                
                <div class="mt-4 p-3 bg-light rounded">
                    <h6>💡 Tips para mejorar tu productividad</h6>
                    <ul class="small mb-0">
                        <li>Usa los atajos de teclado (Ctrl+?) para acciones rápidas</li>
                        <li>El asistente (🤖) puede ayudarte a encontrar lo que necesitas</li>
                        <li>Exporta reportes regularmente para mantener control</li>
                        <li>Revisa las alertas de stock para evitar desabastecimientos</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Sistema de Métricas de Tiempo
let startTime = Date.now();
let tiempoProductivo = 0;
let ultimaActividad = Date.now();

function actualizarTiempoSesion() {
    const elapsed = Date.now() - startTime;
    const hours = Math.floor(elapsed / 3600000);
    const minutes = Math.floor((elapsed % 3600000) / 60000);
    const seconds = Math.floor((elapsed % 60000) / 1000);
    
    document.getElementById('tiempoSesion').textContent = 
        `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
    
    document.getElementById('estadisticaSesion').textContent = 
        `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
}

// Sistema de Eficiencia
function calcularEficiencia() {
    const busquedas = parseInt(localStorage.getItem('contador_busquedas') || '0');
    const movimientos = <?= $movimientosHoy ?? '0' ?>;
    const tiempoActivo = (Date.now() - startTime) / 60000; // minutos
    
    let eficiencia = 0;
    if (tiempoActivo > 0) {
        eficiencia = Math.min(100, ((movimientos + busquedas) / tiempoActivo) * 10);
    }
    
    document.getElementById('eficienciaUsuario').textContent = Math.round(eficiencia) + '%';
    
    // Calcular puntos de productividad
    const puntos = movimientos * 2 + busquedas;
    document.getElementById('productividadUsuario').textContent = puntos;
    
    // Verificar logros
    verificarLogros(movimientos, busquedas, puntos);
}

// Sistema de Logros
function verificarLogros(movimientos, busquedas, puntos) {
    const logros = [];
    const logrosContainer = document.getElementById('logrosUsuario');
    
    if (movimientos >= 10) logros.push({nombre: '🚀 Productivo', desc: '10+ movimientos en un día'});
    if (busquedas >= 5) logros.push({nombre: '🔍 Buscador', desc: '5+ búsquedas realizadas'});
    if (puntos >= 50) logros.push({nombre: '💪 Eficiente', desc: '50+ puntos de productividad'});
    if (movimientos >= 5 && busquedas >= 3) logros.push({nombre: '⭐ Equilibrado', desc: 'Balance en actividades'});
    
    if (logros.length === 0) {
        logrosContainer.innerHTML = '<span class="text-muted small">Sigue usando el sistema para desbloquear logros</span>';
    } else {
        let html = '';
        logros.forEach(logro => {
            html += `<span class="badge bg-success" title="${logro.desc}">${logro.nombre}</span>`;
        });
        logrosContainer.innerHTML = html;
    }
}

// Sistema de Feedback
let puntuacionSeleccionada = 0;

function resaltarEstrellas(hasta) {
    const estrellas = document.querySelectorAll('.estrella-calificacion');
    estrellas.forEach((estrella, index) => {
        if (index < hasta) {
            estrella.classList.add('text-warning');
            estrella.classList.remove('text-muted');
        }
    });
}

function restablecerEstrellas() {
    const estrellas = document.querySelectorAll('.estrella-calificacion');
    estrellas.forEach((estrella, index) => {
        if (index >= puntuacionSeleccionada) {
            estrella.classList.remove('text-warning');
            estrella.classList.add('text-muted');
        }
    });
}

function seleccionarEstrellas(puntuacion) {
    puntuacionSeleccionada = puntuacion;
    const estrellas = document.querySelectorAll('.estrella-calificacion');
    estrellas.forEach((estrella, index) => {
        if (index < puntuacion) {
            estrella.classList.add('text-warning');
            estrella.classList.remove('text-muted');
        } else {
            estrella.classList.remove('text-warning');
            estrella.classList.add('text-muted');
        }
    });
}

function mostrarFeedback() {
    puntuacionSeleccionada = 0;
    document.getElementById('mensajeFeedback').value = '';
    restablecerEstrellas();
    
    const modal = new bootstrap.Modal(document.getElementById('feedbackModal'));
    modal.show();
}

function enviarFeedback() {
    const tipo = document.getElementById('tipoFeedback').value;
    const mensaje = document.getElementById('mensajeFeedback').value;
    
    if (!mensaje.trim()) {
        mostrarNotificacion('Por favor escribe tu mensaje', 'warning');
        return;
    }
    
    // Simular envío de feedback
    const feedback = {
        tipo: tipo,
        mensaje: mensaje,
        puntuacion: puntuacionSeleccionada,
        usuario: '<?= $_SESSION['usuario']['usuario'] ?? 'Anónimo' ?>',
        fecha: new Date().toISOString(),
        pagina: window.location.href
    };
    
    // Guardar en localStorage (en producción enviarías a un servidor)
    let historialFeedback = JSON.parse(localStorage.getItem('historial_feedback') || '[]');
    historialFeedback.push(feedback);
    localStorage.setItem('historial_feedback', JSON.stringify(historialFeedback));
    
    // Cerrar modal y mostrar confirmación
    bootstrap.Modal.getInstance(document.getElementById('feedbackModal')).hide();
    mostrarNotificacion('✅ ¡Gracias por tu feedback! Tu opinión nos ayuda a mejorar.', 'success');
    
    // Registrar actividad positiva
    registrarActividad('feedback_enviado');
}

function mostrarEstadisticas() {
    // Actualizar contadores
    document.getElementById('estadisticaBusquedas').textContent = 
        localStorage.getItem('contador_busquedas') || '0';
    document.getElementById('estadisticaVisitados').textContent = 
        JSON.parse(localStorage.getItem('productos_recientes') || '[]').length;
    
    const modal = new bootstrap.Modal(document.getElementById('estadisticasModal'));
    modal.show();
}

// Registrar actividad del usuario
function registrarActividad(tipo) {
    let actividades = JSON.parse(localStorage.getItem('actividades_usuario') || '[]');
    actividades.push({
        tipo: tipo,
        timestamp: Date.now(),
        pagina: window.location.pathname
    });
    
    // Mantener solo las últimas 100 actividades
    actividades = actividades.slice(-100);
    localStorage.setItem('actividades_usuario', JSON.stringify(actividades));
}

// Contador de búsquedas
function incrementarContadorBusquedas() {
    let contador = parseInt(localStorage.getItem('contador_busquedas') || '0');
    contador++;
    localStorage.setItem('contador_busquedas', contador.toString());
    calcularEficiencia();
}

// Inicialización
document.addEventListener('DOMContentLoaded', function() {
    // Iniciar contador de tiempo
    setInterval(actualizarTiempoSesion, 1000);
    setInterval(calcularEficiencia, 30000); // Cada 30 segundos
    
    // Registrar actividad inicial
    registrarActividad('pagina_cargada');
    
    // Configurar detección de inactividad
    setInterval(() => {
        const inactividad = Date.now() - ultimaActividad;
        if (inactividad > 300000) { // 5 minutos
            registrarActividad('sesion_inactiva');
        }
    }, 60000);
});

// Detectar actividad del usuario
document.addEventListener('mousemove', function() {
    ultimaActividad = Date.now();
});

document.addEventListener('keypress', function() {
    ultimaActividad = Date.now();
});

// Para el archivo listar.php - Incrementar contador en búsquedas
function realizarBusqueda() {
    incrementarContadorBusquedas();
    // ... resto del código de búsqueda
}
</script>

<style>
.metric-small {
    padding: 10px;
}

.estrella-calificacion {
    cursor: pointer;
    transition: all 0.2s ease;
}

.estrella-calificacion:hover {
    transform: scale(1.2);
}

.bg-gradient-primary {
    background: linear-gradient(135deg, #007bff, #0056b3);
}
</style>
</body>
</html>