<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require __DIR__ . '/../config/db.php';
$user = $_SESSION['usuario'] ?? null;

// Obtener alertas de stock bajo (solo si el usuario está logueado)
$alertasStockBajo = [];
$totalAlertas = 0;
if ($user) {
    $stmt = $pdo->prepare("
        SELECT codigo, stock, unidad, stock_minimo
        FROM cintas 
        WHERE activo = 1 AND stock < stock_minimo
        ORDER BY stock ASC 
        LIMIT 10
    ");
    $stmt->execute();
    $alertasStockBajo = $stmt->fetchAll();
    $totalAlertas = count($alertasStockBajo);
}

// Función para traducir unidad en el header
function traducirUnidadHeader($u) {
    switch ($u) {
        case 'm': return 'm';
        case 'kg': return 'kg';
        case 'u': return 'u';
        default: return $u;
    }
}

// Actualizar último login del usuario
if ($user) {
    $stmt = $pdo->prepare("UPDATE usuarios SET ultimo_login = NOW() WHERE id = ?");
    $stmt->execute([$user['id']]);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Control Inventario - Jusocar</title>
  <link rel="stylesheet" href="/inventario/assets/style.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <style>
    .bg-light-green {
        background-color: #d4edda !important;
    }
    .bg-light-red {
        background-color: #f8d7da !important;
    }
    .navbar-brand {
        font-weight: 600;
    }
    .alert-badge {
        position: absolute;
        top: -5px;
        right: -5px;
        font-size: 0.7em;
    }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="/inventario/index.php">
      🏭 Jusocar - Control Inventario
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#menuNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="menuNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
          <a class="nav-link" href="/inventario/index.php">
            <i class="bi bi-house-door"></i> Inicio
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="/inventario/cintas/listar.php">
            <i class="bi bi-box-seam"></i> Inventario
          </a>
        </li>
        <?php if ($user && $user['rol'] !== 'auditor'): ?>
          <li class="nav-item">
            <a class="nav-link" href="/inventario/movimientos/ingreso.php">
              <i class="bi bi-plus-circle"></i> Ingreso
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/inventario/movimientos/salida.php">
              <i class="bi bi-dash-circle"></i> Salida
            </a>
          </li>
        <?php endif; ?>
        <li class="nav-item">
          <a class="nav-link" href="/inventario/movimientos/historial.php">
            <i class="bi bi-clock-history"></i> Historial
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="/inventario/reportes/generar.php?periodo=mes">
            <i class="bi bi-graph-up"></i> Reportes
          </a>
        </li>
        <?php if ($user && $user['rol'] === 'admin'): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-gear"></i> Administrar
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="/inventario/auth/register.php">
                <i class="bi bi-people"></i> Usuarios
              </a></li>
              <li><a class="dropdown-item" href="/inventario/categorias/agregar.php">
                <i class="bi bi-tags"></i> Categorías
              </a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="/inventario/reportes/generar.php?periodo=stock">
                <i class="bi bi-download"></i> Reporte Completo
              </a></li>
            </ul>
          </li>
        <?php endif; ?>
      </ul>
      
      <!-- Información del usuario -->
      <ul class="navbar-nav">
        <?php if ($user): ?>
          <!-- Alertas de stock en navbar -->
          <?php if ($totalAlertas > 0): ?>
            <li class="nav-item dropdown">
              <a class="nav-link position-relative" href="#" role="button" data-bs-toggle="dropdown">
                <i class="bi bi-exclamation-triangle text-warning"></i>
                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger alert-badge">
                  <?= $totalAlertas ?>
                </span>
              </a>
              <ul class="dropdown-menu dropdown-menu-end" style="min-width: 350px;">
                <li><span class="dropdown-item-text fw-bold text-warning">
                  <i class="bi bi-exclamation-triangle"></i> 
                  <?= $totalAlertas ?> Alerta(s) de Stock
                </span></li>
                <?php foreach ($alertasStockBajo as $alerta): 
                  $porcentaje = ($alerta['stock'] / $alerta['stock_minimo']) * 100;
                ?>
                  <li>
                    <a class="dropdown-item" href="/inventario/cintas/listar.php?q=<?= urlencode($alerta['codigo']) ?>">
                      <div class="d-flex w-100 justify-content-between">
                        <strong><?= htmlspecialchars($alerta['codigo']) ?></strong>
                        <small class="text-<?= $porcentaje < 25 ? 'danger' : 'warning' ?>">
                          <?= number_format($porcentaje, 0) ?>%
                        </small>
                      </div>
                      <small class="text-muted">
                        Stock: <?= number_format($alerta['stock'], 0, '', '.') ?> 
                        <?= traducirUnidadHeader($alerta['unidad']) ?> | 
                        Mínimo: <?= number_format($alerta['stock_minimo'], 0, '', '.') ?>
                      </small>
                    </a>
                  </li>
                <?php endforeach; ?>
                <li><hr class="dropdown-divider"></li>
                <li>
                  <a class="dropdown-item text-center" href="/inventario/cintas/listar.php">
                    <small>Gestionar Stock</small>
                  </a>
                </li>
              </ul>
            </li>
          <?php endif; ?>
          
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-person-circle"></i> 
              <?= htmlspecialchars($user['usuario']) ?>
              <span class="badge bg-light text-dark"><?= htmlspecialchars($user['rol']) ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
              <li><span class="dropdown-item-text">
                <small>
                  <i class="bi bi-person"></i> 
                  <strong><?= htmlspecialchars($user['usuario']) ?></strong>
                </small>
                <br>
                <small class="text-muted">
                  <i class="bi bi-shield-check"></i> 
                  <?= htmlspecialchars($user['rol']) ?>
                </small>
              </span></li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <a class="dropdown-item" href="/inventario/index.php">
                  <i class="bi bi-speedometer2"></i> Dashboard
                </a>
              </li>
              <li>
                <a class="dropdown-item" href="/inventario/cintas/listar.php">
                  <i class="bi bi-box-seam"></i> Ver Inventario
                </a>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <a class="dropdown-item text-danger" href="/inventario/auth/logout.php">
                  <i class="bi bi-box-arrow-right"></i> Cerrar Sesión
                </a>
              </li>
            </ul>
          </li>
          
        <?php else: ?>
          <li class="nav-item">
            <a class="nav-link" href="/inventario/auth/login.php">
              <i class="bi bi-box-arrow-in-right"></i> Iniciar Sesión
            </a>
          </li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>


<!-- Asistente IA Flotante -->
<div class="position-fixed bottom-0 start-0 p-3" style="z-index: 1040">
    <button class="btn btn-primary btn-lg rounded-pill shadow-lg hover-lift" 
            data-bs-toggle="modal" data-bs-target="#asistenteModal"
            title="Asistente de Inventario (Ctrl+/)">
        <i class="bi bi-robot"></i>
    </button>
</div>

<!-- Modal del Asistente -->
<div class="modal fade" id="asistenteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary text-white">
                <h5 class="modal-title">🤖 Asistente de Inventario</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label fw-semibold">¿Qué necesitas hacer?</label>
                    <div class="input-group">
                        <input type="text" class="form-control rounded-pill" 
                               placeholder="Ej: Ver productos con stock bajo, Generar reporte mensual, Buscar SARGA..." 
                               id="asistenteInput">
                        <button class="btn btn-primary rounded-pill" onclick="consultarAsistente()">
                            <i class="bi bi-send"></i>
                        </button>
                    </div>
                    <div class="form-text">
                        💡 Ejemplos: "stock bajo", "reporte mensual", "nuevo ingreso", "historial"
                    </div>
                </div>
                
                <div id="asistenteRespuesta" class="mt-4">
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-robot display-4 opacity-25"></i>
                        <p class="mt-3">Escribe arriba lo que necesitas y te ayudaré</p>
                    </div>
                </div>
                
                <!-- Acciones Rápidas Predefinidas -->
                <div class="row g-2 mt-3" id="accionesRapidas">
                    <div class="col-md-3">
                        <button class="btn btn-outline-warning w-100 btn-sm" onclick="asistenteAccionRapida('stock bajo')">
                            ⚠️ Stock Bajo
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-outline-info w-100 btn-sm" onclick="asistenteAccionRapida('reporte mensual')">
                            📊 Reporte
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-outline-success w-100 btn-sm" onclick="asistenteAccionRapida('nuevo ingreso')">
                            ➕ Ingreso
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-outline-primary w-100 btn-sm" onclick="asistenteAccionRapida('historial movimientos')">
                            📜 Historial
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Asistente IA
function consultarAsistente() {
    const query = document.getElementById('asistenteInput').value.trim();
    const respuestaDiv = document.getElementById('asistenteRespuesta');
    
    if (!query) {
        mostrarNotificacion('Por favor escribe lo que necesitas', 'warning');
        return;
    }
    
    // Mostrar loading
    respuestaDiv.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Analizando...</span>
            </div>
            <p class="mt-2 text-muted">Analizando tu consulta...</p>
        </div>
    `;
    
    fetch(`/inventario/asistente.php?q=${encodeURIComponent(query)}`)
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                respuestaDiv.innerHTML = `
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i> ${data.error}
                    </div>
                `;
                return;
            }
            
            let html = '';
            
            // Mostrar sugerencias si existen
            if (data.sugerencias && data.sugerencias.length > 0) {
                html += `<div class="alert alert-info">`;
                data.sugerencias.forEach(sug => {
                    html += `<div>💡 ${sug}</div>`;
                });
                html += `</div>`;
            }
            
            // Mostrar acciones
            if (data.acciones && data.acciones.length > 0) {
                html += `<h6 class="mb-3">Acciones sugeridas:</h6>`;
                html += `<div class="row g-3">`;
                
                data.acciones.forEach(accion => {
                    html += `
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm hover-lift">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3 fs-4">
                                            ${accion.icono}
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="card-title mb-1">${accion.titulo}</h6>
                                            <p class="card-text small text-muted mb-2">${accion.descripcion}</p>
                                            <a href="${accion.url}" class="btn btn-sm btn-primary rounded-pill">
                                                Ir <i class="bi bi-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });
                
                html += `</div>`;
            } else {
                html += `
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-question-circle display-4 opacity-25"></i>
                        <p class="mt-3">No encontré acciones específicas para "${data.query}"</p>
                        <p class="small">Intenta ser más específico o usa una de las acciones rápidas.</p>
                    </div>
                `;
            }
            
            respuestaDiv.innerHTML = html;
        })
        .catch(error => {
            console.error('Error:', error);
            respuestaDiv.innerHTML = `
                <div class="alert alert-danger">
                    <i class="bi bi-exclamation-triangle"></i> Error al consultar el asistente
                </div>
            `;
        });
}

// Acciones rápidas del asistente
function asistenteAccionRapida(accion) {
    document.getElementById('asistenteInput').value = accion;
    consultarAsistente();
}

// Atajo de teclado para el asistente (Ctrl+/)
document.addEventListener('keydown', function(e) {
    if (e.ctrlKey && e.key === '/') {
        e.preventDefault();
        const asistenteModal = new bootstrap.Modal(document.getElementById('asistenteModal'));
        asistenteModal.show();
        
        // Enfocar el input después de que el modal se muestre
        setTimeout(() => {
            document.getElementById('asistenteInput').focus();
        }, 500);
    }
});

// Buscar al presionar Enter en el asistente
document.getElementById('asistenteInput').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        consultarAsistente();
    }
});
</script>

<!-- Sistema de Alertas Programadas -->
<script>
// Verificar alertas al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    verificarAlertasProgramadas();
    
    // Verificar cada 5 minutos
    setInterval(verificarAlertasProgramadas, 300000);
});

function verificarAlertasProgramadas() {
    // Simular verificación de alertas (en una implementación real, esto vendría del servidor)
    const alertas = JSON.parse(localStorage.getItem('alertas_pendientes') || '[]');
    
    // Alertas de ejemplo (en producción vendrían de una API)
    const alertasEjemplo = [
        {
            tipo: 'stock_bajo',
            mensaje: '⚠️ 3 productos con stock bajo',
            url: '/inventario/cintas/listar.php?stock=bajo',
            timestamp: Date.now()
        },
        {
            tipo: 'stock_critico', 
            mensaje: '🚨 1 producto con stock crítico',
            url: '/inventario/cintas/listar.php?stock=critico',
            timestamp: Date.now() - 3600000 // 1 hora atrás
        }
    ];
    
    // Mostrar alertas no vistas
    alertasEjemplo.forEach(alerta => {
        const vistaKey = `alerta_vista_${alerta.tipo}_${new Date(alerta.timestamp).toDateString()}`;
        if (!localStorage.getItem(vistaKey)) {
            setTimeout(() => {
                mostrarNotificacion(
                    `${alerta.mensaje} <a href="${alerta.url}" class="alert-link">Ver</a>`,
                    alerta.tipo === 'stock_critico' ? 'danger' : 'warning'
                );
                localStorage.setItem(vistaKey, 'true');
            }, 2000);
        }
    });
}

// Sistema de recordatorios
function programarRecordatorio(mensaje, minutos = 5) {
    setTimeout(() => {
        mostrarNotificacion(`🔔 Recordatorio: ${mensaje}`, 'info');
    }, minutos * 60 * 1000);
}

// Ejemplo: Programar recordatorio para revisar stock bajo
function recordatorioRevisionStock() {
    programarRecordatorio('Es un buen momento para revisar el stock bajo', 60); // 1 hora
}

// Iniciar recordatorios al cargar
document.addEventListener('DOMContentLoaded', function() {
    // Solo programar recordatorios si es horario laboral (9 AM - 6 PM)
    const hora = new Date().getHours();
    if (hora >= 9 && hora <= 18) {
        setTimeout(recordatorioRevisionStock, 10000); // 10 segundos después de cargar
    }
});
</script>





<!-- Alertas globales de stock bajo -->
<?php if ($user && $totalAlertas > 0 && basename($_SERVER['PHP_SELF']) == 'index.php'): ?>
<div class="container mt-3">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
    <h6 class="alert-heading">
      <i class="bi bi-exclamation-triangle"></i> 
      Tienes <?= $totalAlertas ?> producto(s) con stock bajo
    </h6>
    <div class="row">
      <?php foreach (array_slice($alertasStockBajo, 0, 4) as $alerta): 
        $porcentaje = ($alerta['stock'] / $alerta['stock_minimo']) * 100;
      ?>
        <div class="col-md-3 mb-2">
          <strong><?= htmlspecialchars($alerta['codigo']) ?></strong>
          <br>
          <small class="text-muted">
            Stock: <?= number_format($alerta['stock'], 0, '', '.') ?> 
            <?= $alerta['unidad'] ?> | 
            <span class="text-<?= $porcentaje < 25 ? 'danger' : 'warning' ?>">
              <?= number_format($porcentaje, 0) ?>% del mínimo
            </span>
          </small>
        </div>
      <?php endforeach; ?>
      <?php if ($totalAlertas > 4): ?>
        <div class="col-md-12 mt-2">
          <em>... y <?= $totalAlertas - 4 ?> más</em>
        </div>
      <?php endif; ?>
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    <div class="mt-2">
      <a href="/inventario/cintas/listar.php" class="btn btn-sm btn-warning">Gestionar Stock</a>
    </div>
  </div>
</div>
<?php endif; ?>




<!-- Sistema de Favoritos/Recientes -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1040">
    <div class="btn-group-vertical">
        <button class="btn btn-info btn-sm rounded-pill mb-2" onclick="mostrarAtajos()" 
                title="Atajos de teclado (Ctrl+H)">
            <i class="bi bi-keyboard"></i>
        </button>
        <button class="btn btn-warning btn-sm rounded-pill" onclick="mostrarRecientes()" 
                title="Productos recientes">
            <i class="bi bi-clock-history"></i>
        </button>
    </div>
</div>

<!-- Modal de Atajos -->
<div class="modal fade" id="atajosModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary text-white">
                <h5 class="modal-title">⌨️ Atajos de Teclado</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Navegación Principal</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2">
                                <kbd>Ctrl + N</kbd> 
                                <span class="text-muted">Nuevo producto</span>
                            </li>
                            <li class="mb-2">
                                <kbd>Ctrl + I</kbd> 
                                <span class="text-muted">Nuevo ingreso</span>
                            </li>
                            <li class="mb-2">
                                <kbd>Ctrl + S</kbd> 
                                <span class="text-muted">Buscar productos</span>
                            </li>
                            <li class="mb-2">
                                <kbd>Ctrl + H</kbd> 
                                <span class="text-muted">Ver historial</span>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6>Acciones Rápidas</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2">
                                <kbd>Ctrl + R</kbd> 
                                <span class="text-muted">Generar reporte</span>
                            </li>
                            <li class="mb-2">
                                <kbd>Ctrl + D</kbd> 
                                <span class="text-muted">Ir al dashboard</span>
                            </li>
                            <li class="mb-2">
                                <kbd>Ctrl + L</kbd> 
                                <span class="text-muted">Limpiar búsqueda</span>
                            </li>
                            <li class="mb-2">
                                <kbd>Esc</kbd> 
                                <span class="text-muted">Cerrar modales</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Recientes -->
<div class="modal fade" id="recientesModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-gradient-warning text-white">
                <h5 class="modal-title">⭐ Productos y Acciones Recientes</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>📦 Productos Visitados</h6>
                        <div id="listaRecientes">
                            <!-- Se llena con JavaScript -->
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h6>⚡ Acciones Frecuentes</h6>
                        <div class="d-grid gap-2">
                            <a href="/inventario/movimientos/ingreso.php" 
                               class="btn btn-outline-success btn-sm">
                                <i class="bi bi-plus-circle"></i> Nuevo Ingreso
                            </a>
                            <a href="/inventario/movimientos/salida.php" 
                               class="btn btn-outline-danger btn-sm">
                                <i class="bi bi-dash-circle"></i> Nueva Salida
                            </a>
                            <a href="/inventario/reportes/generar.php?periodo=mes" 
                               class="btn btn-outline-warning btn-sm">
                                <i class="bi bi-graph-up"></i> Reporte Mensual
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Sistema de Productos Recientes
function guardarProductoReciente(codigo, descripcion) {
    let recientes = JSON.parse(localStorage.getItem('productos_recientes') || '[]');
    
    // Evitar duplicados
    recientes = recientes.filter(item => item.codigo !== codigo);
    
    // Agregar al inicio
    recientes.unshift({
        codigo: codigo,
        descripcion: descripcion,
        timestamp: Date.now()
    });
    
    // Mantener solo los últimos 10
    recientes = recientes.slice(0, 10);
    
    localStorage.setItem('productos_recientes', JSON.stringify(recientes));
}

function cargarProductosRecientes() {
    const recientes = JSON.parse(localStorage.getItem('productos_recientes') || '[]');
    const lista = document.getElementById('listaRecientes');
    
    if (recientes.length === 0) {
        lista.innerHTML = '<p class="text-muted small">No hay productos recientes</p>';
        return;
    }
    
    let html = '';
    recientes.forEach(item => {
        const tiempo = Math.floor((Date.now() - item.timestamp) / (1000 * 60)); // minutos
        const tiempoTexto = tiempo < 60 ? `${tiempo} min` : `${Math.floor(tiempo / 60)} h`;
        
        html += `
            <div class="d-flex justify-content-between align-items-center mb-2 p-2 border rounded">
                <div>
                    <strong class="small">${item.codigo}</strong>
                    <br>
                    <small class="text-muted">${item.descripcion.substring(0, 30)}...</small>
                </div>
                <div>
                    <a href="/inventario/cintas/listar.php?q=${encodeURIComponent(item.codigo)}" 
                       class="btn btn-sm btn-outline-primary" title="Buscar este producto">
                        <i class="bi bi-search"></i>
                    </a>
                    <small class="text-muted d-block">${tiempoTexto}</small>
                </div>
            </div>
        `;
    });
    
    lista.innerHTML = html;
}

// Atajos de Teclado
document.addEventListener('keydown', function(e) {
    // Solo activar si no estamos en un input de texto
    if (e.target.tagName === 'INPUT' || e.target.tagName === 'TEXTAREA') {
        return;
    }
    
    // Ctrl + N: Nuevo producto
    if (e.ctrlKey && e.key === 'n') {
        e.preventDefault();
        window.location.href = '/inventario/cintas/agregar.php';
    }
    // Ctrl + I: Nuevo ingreso
    if (e.ctrlKey && e.key === 'i') {
        e.preventDefault();
        window.location.href = '/inventario/movimientos/ingreso.php';
    }
    // Ctrl + S: Buscar
    if (e.ctrlKey && e.key === 's') {
        e.preventDefault();
        const searchInput = document.querySelector('input[name="q"]');
        if (searchInput) {
            searchInput.focus();
            searchInput.select();
        }
    }
    // Ctrl + H: Historial
    if (e.ctrlKey && e.key === 'h') {
        e.preventDefault();
        window.location.href = '/inventario/movimientos/historial.php';
    }
    // Ctrl + R: Reportes
    if (e.ctrlKey && e.key === 'r') {
        e.preventDefault();
        window.location.href = '/inventario/reportes/generar.php';
    }
    // Ctrl + D: Dashboard
    if (e.ctrlKey && e.key === 'd') {
        e.preventDefault();
        window.location.href = '/inventario/index.php';
    }
    // Ctrl + L: Limpiar búsqueda
    if (e.ctrlKey && e.key === 'l') {
        e.preventDefault();
        window.location.href = window.location.pathname;
    }
    // Esc: Cerrar modales
    if (e.key === 'Escape') {
        const modales = document.querySelectorAll('.modal');
        modales.forEach(modal => {
            const bsModal = bootstrap.Modal.getInstance(modal);
            if (bsModal) bsModal.hide();
        });
    }
    // Ctrl + ?: Mostrar ayuda
    if (e.ctrlKey && e.key === '?') {
        e.preventDefault();
        mostrarAtajos();
    }
});

// Funciones de ayuda
function mostrarAtajos() {
    const modal = new bootstrap.Modal(document.getElementById('atajosModal'));
    modal.show();
}

function mostrarRecientes() {
    cargarProductosRecientes();
    const modal = new bootstrap.Modal(document.getElementById('recientesModal'));
    modal.show();
}

// Inicialización
document.addEventListener('DOMContentLoaded', function() {
    // Guardar página actual como reciente si es un producto
    const urlParams = new URLSearchParams(window.location.search);
    const productoId = urlParams.get('id');
    const busqueda = urlParams.get('q');
    
    if (productoId || busqueda) {
        // Simular guardado de producto reciente (en una implementación real, esto vendría del servidor)
        setTimeout(() => {
            if (busqueda) {
                guardarProductoReciente(busqueda, `Búsqueda: ${busqueda}`);
            }
        }, 1000);
    }
    
    // Mostrar notificación de atajos al cargar
    setTimeout(() => {
        if (!localStorage.getItem('atajos_vistos')) {
            mostrarNotificacion('💡 Usa Ctrl+? para ver atajos de teclado', 'info');
            localStorage.setItem('atajos_vistos', 'true');
        }
    }, 2000);
});

// Función global para notificaciones (si no existe)
if (typeof mostrarNotificacion === 'undefined') {
    function mostrarNotificacion(mensaje, tipo = 'info') {
        // Crear notificación temporal si no existe el sistema completo
        const alert = document.createElement('div');
        alert.className = `alert alert-${tipo} alert-dismissible fade show position-fixed top-0 start-50 translate-middle-x mt-3`;
        alert.style.zIndex = '1060';
        alert.innerHTML = `
            ${mensaje}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.body.appendChild(alert);
        
        setTimeout(() => {
            alert.remove();
        }, 3000);
    }
}
</script>



<div class="container mt-4">