<?php
require __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$user = $_SESSION['usuario'];

// Obtener métricas para el dashboard
$stmt = $pdo->query("SELECT COUNT(*) as total FROM cintas WHERE activo = 1");
$totalProductos = $stmt->fetchColumn();

$stmt = $pdo->query("
    SELECT COUNT(*) as bajos 
    FROM cintas 
    WHERE activo = 1 AND stock < stock_minimo
");
$stockBajo = $stmt->fetchColumn();

$stmt = $pdo->query("
    SELECT SUM(stock * precio_unitario) as valor 
    FROM cintas 
    WHERE activo = 1
");
$valorTotal = $stmt->fetchColumn();
$valorTotal = $valorTotal ?: 0;

// Movimientos del mes
$stmt = $pdo->query("
    SELECT COUNT(*) as movimientos 
    FROM movimientos m
    JOIN cintas c ON m.cinta_id = c.id
    WHERE MONTH(m.fecha) = MONTH(CURDATE()) 
    AND YEAR(m.fecha) = YEAR(CURDATE())
    AND c.activo = 1
");
$movimientosMes = $stmt->fetchColumn();

// Productos con stock crítico (menos del 50% del mínimo)
$stmt = $pdo->query("
    SELECT COUNT(*) as criticos 
    FROM cintas 
    WHERE activo = 1 AND stock < (stock_minimo * 0.5)
");
$stockCritico = $stmt->fetchColumn();

// Últimos movimientos
$ultimosMovimientos = $pdo->query("
    SELECT m.tipo, m.cantidad, m.unidad, m.fecha, c.codigo, c.descripcion,
           cat.nombre as categoria
    FROM movimientos m
    JOIN cintas c ON m.cinta_id = c.id
    LEFT JOIN categorias cat ON c.categoria_id = cat.id
    WHERE c.activo = 1
    ORDER BY m.fecha DESC 
    LIMIT 8
")->fetchAll();
?>
<h2 class="mb-4">
  👋 Bienvenido, <?= htmlspecialchars($user['usuario']) ?> 
  <span class="badge bg-gradient-secondary"><?= htmlspecialchars($user['rol']) ?></span>
</h2>

<!-- Dashboard de Métricas Mejorado -->
<div class="row mt-4 mb-4">
  <div class="col-xl-2 col-md-4 mb-3">
    <div class="card metric-card bg-gradient-primary text-white hover-lift">
      <div class="card-body text-center py-4">
        <div class="metric-icon mb-2">📦</div>
        <h3 class="metric-value fw-bold"><?= number_format($totalProductos, 0, '', '.') ?></h3>
        <small class="metric-label">Productos Activos</small>
      </div>
    </div>
  </div>
  <div class="col-xl-2 col-md-4 mb-3">
    <div class="card metric-card bg-gradient-warning text-white hover-lift">
      <div class="card-body text-center py-4">
        <div class="metric-icon mb-2">⚠️</div>
        <h3 class="metric-value fw-bold"><?= number_format($stockBajo, 0, '', '.') ?></h3>
        <small class="metric-label">Stock Bajo</small>
      </div>
    </div>
  </div>
  <div class="col-xl-2 col-md-4 mb-3">
    <div class="card metric-card bg-gradient-danger text-white hover-lift">
      <div class="card-body text-center py-4">
        <div class="metric-icon mb-2">🚨</div>
        <h3 class="metric-value fw-bold"><?= number_format($stockCritico, 0, '', '.') ?></h3>
        <small class="metric-label">Stock Crítico</small>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-md-6 mb-3">
    <div class="card metric-card bg-gradient-success text-white hover-lift">
      <div class="card-body text-center py-4">
        <div class="metric-icon mb-2">💰</div>
        <h3 class="metric-value fw-bold">$<?= number_format($valorTotal, 0, '', '.') ?></h3>
        <small class="metric-label">Valor Total Inventario</small>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-md-6 mb-3">
    <div class="card metric-card bg-gradient-info text-white hover-lift">
      <div class="card-body text-center py-4">
        <div class="metric-icon mb-2">📊</div>
        <h3 class="metric-value fw-bold"><?= number_format($movimientosMes, 0, '', '.') ?></h3>
        <small class="metric-label">Movimientos Este Mes</small>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <!-- Menú Principal Mejorado -->
  <div class="col-lg-8">
    <div class="card border-0 shadow-sm mb-4">
      <div class="card-header bg-gradient-primary text-white py-3">
        <h5 class="mb-0">🚀 Acciones Rápidas</h5>
      </div>
      <div class="card-body p-4">
        <div class="row g-3">
          <div class="col-md-4">
            <a href="/inventario/cintas/listar.php" class="btn btn-primary w-100 py-3 action-btn hover-lift">
              <i class="bi bi-box-seam display-6 mb-2"></i><br>
              📦 Inventario
            </a>
          </div>
          <?php if ($user['rol'] !== 'auditor'): ?>
            <div class="col-md-4">
              <a href="/inventario/movimientos/ingreso.php" class="btn btn-success w-100 py-3 action-btn hover-lift">
                <i class="bi bi-plus-circle display-6 mb-2"></i><br>
                ➕ Ingreso
              </a>
            </div>
            <div class="col-md-4">
              <a href="/inventario/movimientos/salida.php" class="btn btn-danger w-100 py-3 action-btn hover-lift">
                <i class="bi bi-dash-circle display-6 mb-2"></i><br>
                ➖ Salida
              </a>
            </div>
          <?php endif; ?>
          <div class="col-md-4">
            <a href="/inventario/movimientos/historial.php" class="btn btn-secondary w-100 py-3 action-btn hover-lift">
              <i class="bi bi-clock-history display-6 mb-2"></i><br>
              📜 Historial
            </a>
          </div>
          <div class="col-md-4">
            <a href="/inventario/reportes/generar.php?periodo=mes" class="btn btn-warning w-100 py-3 action-btn hover-lift">
              <i class="bi bi-graph-up display-6 mb-2"></i><br>
              📊 Reportes
            </a>
          </div>
          <?php if ($user['rol'] === 'admin'): ?>
            <div class="col-md-4">
              <a href="/inventario/auth/register.php" class="btn btn-info w-100 py-3 action-btn hover-lift">
                <i class="bi bi-people display-6 mb-2"></i><br>
                👤 Usuarios
              </a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- Últimos Movimientos Mejorado -->
    <div class="card border-0 shadow-sm">
      <div class="card-header bg-light py-3">
        <h5 class="mb-0">🕒 Últimos Movimientos</h5>
      </div>
      <div class="card-body p-0">
        <?php if (empty($ultimosMovimientos)): ?>
          <div class="text-center text-muted py-5">
            <i class="bi bi-inbox display-1 opacity-25"></i>
            <p class="mt-3">No hay movimientos recientes</p>
          </div>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-hover mb-0">
              <thead class="table-light">
                <tr>
                  <th>Fecha</th>
                  <th>Tipo</th>
                  <th>Producto</th>
                  <th>Cantidad</th>
                  <th>Categoría</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($ultimosMovimientos as $mov): ?>
                  <tr class="align-middle">
                    <td>
                      <small class="text-muted"><?= date('d/m H:i', strtotime($mov['fecha'])) ?></small>
                    </td>
                    <td>
                      <span class="badge bg-<?= $mov['tipo'] === 'ingreso' ? 'success' : 'danger' ?> rounded-pill">
                        <?= $mov['tipo'] === 'ingreso' ? '➕' : '➖' ?> <?= ucfirst($mov['tipo']) ?>
                      </span>
                    </td>
                    <td>
                      <small><strong><?= htmlspecialchars($mov['codigo']) ?></strong></small>
                      <br>
                      <small class="text-muted"><?= htmlspecialchars($mov['descripcion']) ?></small>
                    </td>
                    <td class="text-end">
                      <strong><?= number_format($mov['cantidad'], 0, '', '.') ?></strong>
                      <br>
                      <small class="text-muted"><?= $mov['unidad'] ?></small>
                    </td>
                    <td>
                      <span class="badge bg-secondary rounded-pill"><?= htmlspecialchars($mov['categoria']) ?></span>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <div class="text-center p-3 border-top">
            <a href="/inventario/movimientos/historial.php" class="btn btn-sm btn-outline-primary rounded-pill">
              Ver todos los movimientos
            </a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Alertas y Estadísticas Mejoradas -->
  <div class="col-lg-4">
    <!-- Alertas de Stock Bajo Mejoradas -->
    <?php
    $productosBajoStock = $pdo->query("
        SELECT c.*, cat.nombre as categoria 
        FROM cintas c 
        LEFT JOIN categorias cat ON c.categoria_id = cat.id 
        WHERE c.activo = 1 AND c.stock < c.stock_minimo
        ORDER BY c.stock ASC 
        LIMIT 8
    ")->fetchAll();
    ?>

    <?php if (!empty($productosBajoStock)): ?>
    <div class="card border-warning shadow-sm mb-4">
      <div class="card-header bg-gradient-warning text-white py-3">
        <h6 class="mb-0">⚠️ Alertas de Stock Bajo</h6>
      </div>
      <div class="card-body p-0">
        <div class="list-group list-group-flush">
          <?php foreach ($productosBajoStock as $producto): 
            $porcentaje = ($producto['stock'] / $producto['stock_minimo']) * 100;
            $claseAlerta = $porcentaje < 25 ? 'list-group-item-danger' : 'list-group-item-warning';
          ?>
            <div class="list-group-item <?= $claseAlerta ?> py-3 border-0">
              <div class="d-flex w-100 justify-content-between align-items-start">
                <div class="flex-grow-1">
                  <strong class="mb-1"><?= htmlspecialchars($producto['codigo']) ?></strong>
                  <p class="mb-1 small">
                    Stock: <strong><?= number_format($producto['stock'], 0, '', '.') ?></strong> 
                    <?= $producto['unidad'] ?> | 
                    Mínimo: <?= number_format($producto['stock_minimo'], 0, '', '.') ?>
                  </p>
                  <small class="text-muted"><?= htmlspecialchars($producto['categoria']) ?></small>
                </div>
                <div class="ps-3">
                  <span class="badge bg-<?= $porcentaje < 25 ? 'danger' : 'warning' ?> rounded-pill">
                    <?= number_format($porcentaje, 0) ?>%
                  </span>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
        <div class="p-3 border-top">
          <a href="/inventario/cintas/listar.php" class="btn btn-sm btn-warning w-100 rounded-pill">
            Gestionar Stock
          </a>
        </div>
      </div>
    </div>
    <?php endif; ?>

    <!-- Estadísticas Rápidas Mejoradas -->
    <div class="card border-0 shadow-sm mb-4">
      <div class="card-header bg-light py-3">
        <h6 class="mb-0">📈 Estadísticas</h6>
      </div>
      <div class="card-body">
        <?php
        // Productos por categoría
        $categoriasStats = $pdo->query("
            SELECT cat.nombre, COUNT(c.id) as total
            FROM categorias cat
            LEFT JOIN cintas c ON cat.id = c.categoria_id AND c.activo = 1
            GROUP BY cat.id, cat.nombre
            ORDER BY total DESC
        ")->fetchAll();
        ?>
        
        <h6 class="mb-3">Productos por Categoría:</h6>
        <?php foreach ($categoriasStats as $cat): ?>
          <div class="d-flex justify-content-between align-items-center mb-2 p-2 rounded hover-bg">
            <span class="small"><?= htmlspecialchars($cat['nombre']) ?></span>
            <span class="badge bg-primary rounded-pill"><?= $cat['total'] ?></span>
          </div>
        <?php endforeach; ?>

        <hr>
        
        <?php
        // Movimientos hoy
        $movimientosHoy = $pdo->query("
            SELECT COUNT(*) as total
            FROM movimientos 
            WHERE DATE(fecha) = CURDATE()
        ")->fetchColumn();
        ?>
        
        <div class="row text-center">
          <div class="col-6">
            <div class="border rounded p-3 hover-lift">
              <div class="h4 mb-1 text-primary fw-bold"><?= $movimientosHoy ?></div>
              <small class="text-muted">Hoy</small>
            </div>
          </div>
          <div class="col-6">
            <div class="border rounded p-3 hover-lift">
              <div class="h4 mb-1 text-success fw-bold"><?= $movimientosMes ?></div>
              <small class="text-muted">Este Mes</small>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Acciones Administrativas Mejoradas -->
    <?php if ($user['rol'] === 'admin'): ?>
    <div class="card border-info shadow-sm">
      <div class="card-header bg-gradient-info text-white py-3">
        <h6 class="mb-0">⚙️ Administración</h6>
      </div>
      <div class="card-body">
        <div class="d-grid gap-2">
          <a href="/inventario/categorias/agregar.php" class="btn btn-outline-info btn-sm rounded-pill py-2">
            📂 Gestionar Categorías
          </a>
          <a href="/inventario/auth/register.php" class="btn btn-outline-info btn-sm rounded-pill py-2">
            👥 Gestionar Usuarios
          </a>
          <a href="/inventario/reportes/generar.php?periodo=stock" class="btn btn-outline-info btn-sm rounded-pill py-2">
            📊 Reporte Completo
          </a>
        </div>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>

<style>
/* Estilos mejorados para el dashboard */
.metric-card {
    border: none;
    border-radius: 15px;
    transition: all 0.3s ease;
}

.metric-icon {
    font-size: 2rem;
    opacity: 0.9;
}

.metric-value {
    font-size: 1.8rem;
    margin-bottom: 0.5rem;
}

.metric-label {
    font-size: 0.85rem;
    opacity: 0.9;
}

.hover-lift:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

.action-btn {
    border-radius: 12px;
    border: none;
    font-weight: 500;
    transition: all 0.3s ease;
}

.action-btn:hover {
    transform: translateY(-2px);
}

.bg-gradient-primary {
    background: linear-gradient(135deg, #007bff, #0056b3);
}

.bg-gradient-secondary {
    background: linear-gradient(135deg, #6c757d, #495057);
}

.bg-gradient-success {
    background: linear-gradient(135deg, #28a745, #1e7e34);
}

.bg-gradient-danger {
    background: linear-gradient(135deg, #dc3545, #c82333);
}

.bg-gradient-warning {
    background: linear-gradient(135deg, #ffc107, #e0a800);
}

.bg-gradient-info {
    background: linear-gradient(135deg, #17a2b8, #138496);
}

.hover-bg:hover {
    background-color: #f8f9fa;
}

.rounded-pill {
    border-radius: 50rem !important;
}

.shadow-sm {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>